/**********************************************************
 * Plugin for jQuery v1.0.0
 **********************************************************
* Source Copyright 2014 Author                            *
* Unauthorized reproduction is not allowed                *
* Author: JPK Software Solutions Pvt. Ltd.                *
* Email: sales@visionhelpdesk.com                         *
* Owner: www.visionhelpdesk.com                           *
**********************************************************/
var curr_stamp=Date.now();

(function($) {
	/* Global Settings for Interface
	-----------------------------------------------------------*/
	var settings={
		'top_toolbar_height' : '30',
		//'left_toolbar_width' : '60',
		'left_panel_width'   : '300', //'250',
		'top_header_height'  : '60',
		'top_toolbar_bgcolor': '#eee',
		'left_toolbar_bgcolor': '#fff',
		'left_panel_bgcolor' : '#fff',
		'work_panel_bgcolor' : '#fff',
		'vis_header_title'	 : '',
		'portal_bgcolor'	 : '#62b600',
		'cache'				 : false,
		'portal_height'		 : 500,
		'portal_width'		 : 1000,
		'direction'			 : "ltr"
	};
	
	/* Global Settings for Tab in Interface
	-----------------------------------------------------------*/
	var tab_settings={'cache':false, 'removable':true};
	var methods={
     	init : function(options, end_action) {
			if(options) {$.extend(settings, options);}
			var $this=$(this);
			
			if($("#vis_header_div").length) {/*$("#vis_header_div").css("height", settings.top_header_height);*/}
			else {
				div=document.createElement("header");
				div.className="bg-primary header header-md navbar navbar-fixed-top-xs";
				div.id="vis_header_div";
				//div.style.height=(settings.top_header_height)+"px";
				$this.append(div);
			}			
			if($("#middle_section").length) {
			/*	var str = $("#vis_workpanel_div").css("height");
				str = str.substring(0, str.length-2)-50;			
				$("#vis_leftpanel_content_div").css("height", str+'px');*/
			}
			else {
				var section1 = document.createElement("section");
				section1.id = "middle_section";
				var section2 = document.createElement("section");
				section2.className = "hbox stretch";
				
				var aside1 = document.createElement("aside");
				aside1.id="vis_left_panel_div";
				aside1.className = "bg-light lt b-r b-light";
				var aside2 = document.createElement("section");
				aside2.id="vis_workpanel";
				aside2.className = "vbox";
				var aside2_section2 = document.createElement("section");
				
				if(GetIEVersion() > 0) 
				{					
				}else{
					aside2_section2.className = "scrollable";
				}
				
				aside2_section2.id = "vis_workpanel_div";
				var aside3 = document.createElement("aside");
				aside3.id="vis_right_panel_div";
				aside3.className = "bg-light lt b-r b-light";
				$this.append(section1);
				section1.appendChild(section2);
				section2.appendChild(aside1);
				section2.appendChild(aside2);
				section2.appendChild(aside3);
				aside2.appendChild(aside2_section2);
			}
			if(end_action) end_action();
		},
		toggle_panel : function(options, callback) {
			if(options) {$.extend(settings, options);}
			if($('#vis_left_panel_div').is(":visible")) {
					$('#vis_left_panel_div').animate({width:'toggle'},250);
					$("#vis_workpanel_div").animate({left:65},250);
					$("#vis_workpanel_div").css("width", (settings.portal_width-settings.left_toolbar_width-8));
					$("#vis_left_bar_cmd_div").show();
					$(".ui-tabs .ui-tabs-nav").css("padding-left", 40);
			}
			else if($('#vis_right_panel_div').is(":visible")) {
					$('#vis_right_panel_div').animate({width:'toggle'},250);
					$("#vis_workpanel_div").animate({left:65},250);
					$("#vis_workpanel_div").css("width", (settings.portal_width-settings.left_toolbar_width-8));
					$("#vis_right_bar_cmd_div").show();
					$(".ui-tabs .ui-tabs-nav").css("padding-left", 40);
			}
			else {
				$('#vis_left_panel_div').animate({width:'toggle'},250);
				$("#vis_workpanel_div").animate({left:319},250);
				$("#vis_workpanel_div").animate({width:settings.portal_width-settings.left_toolbar_width-settings.left_panel_width-12}, 10);
				$("#vis_left_bar_cmd_div").hide();
				$(".ui-tabs .ui-tabs-nav").css("padding-left", 3);
			}
		},				
		switch_subtab : function(options, callback) {
			$(this).parent("#"+options.vis_static_area).find(".vis_sub_header_selected").removeClass("vis_sub_header_selected").addClass("vis_sub_header_normal");
			$(this).removeClass("vis_sub_header_normal").addClass("vis_sub_header_selected");
			
		},
		toogle_display : function(options, callback) {
			var $this=$(this).find(options.vis_static_area);
			if(options.vis_effect && options.vis_effect=="slide") $this.slideToggle("fast", callback);
			else $this.toggle(callback);
		},
		scrollBottom : function(options, callback) {
			$(this).parents('.ui-tabs-panel').animate({scrollTop: $(this).parents('.ui-tabs-panel').height()});
		},
		create_ckeditor : function(options) {
			$this=$(this);
			if(typeof CKEDITOR.instances[$(this).attr("id")]!="undefined") delete CKEDITOR.instances[$(this).attr("id")];
			$this.ckeditor();
			
		},
		translate : function(options) {
			var msg=$(this).html();
			var code=google.language.detect(msg);
			if(msg!=null) google.language.translate(msg, "en", options.tocode, function(result) {
				if (!result.error) {
				  	$("#vis_ticket_post_content_tr_1").html(result.translation).addClass("vis_button");
					return true;
				}
				else alert(result.error.message);
			});
		},
		toogle_list_check : function(options) {
			var form=$(this).parents(options.vis_form);
			if(typeof options.vis_list_status!="undefined") var status=options.vis_list_status;
            else var status=$(this).attr("checked")=="checked";
			if(options.vis_list_status_class!="vis_list_checkbox") $(form).find(".vis_list_checkbox").each( function() {$(this).attr("checked",false);});
			$(form).find(options.vis_list_status_class).each( function() {
				$(this).prop('checked', status); //attr("checked",status);
			});
            /* To disable header & footer mass actions on list pages */
            var checkboxes = $("[id^='vis_ticket_mass_chk_']");
            var checkedAtLeastOne = false;            
            header_dropdown_btns = $(".vis_mass_action"),
            footer_dropdown_btns = $(".vis_mass_action_footer");
            checkedAtLeastOne = checkboxes.is(":checked");
            if(checkedAtLeastOne){
                header_dropdown_btns.removeClass("hide");
                footer_dropdown_btns.removeClass("hide");
            } else {
                header_dropdown_btns.addClass("hide");
                footer_dropdown_btns.addClass("hide");
            }
		},
		load_top_toolbar : function(options) {
			if(options) {$.extend(settings, options);}
			var $this=$(this);
			var length=vis_top_toolbar_list.length;
			for(i=0;i<length;i++) {
				var span=document.createElement('span');
				if(vis_top_toolbar_list[i][0]=="" && vis_top_toolbar_list[i][1]=="") {
					span.className="vis-toolbar-splitter";
				}
				else {
					span.className="vis-toolbar-icon "+ vis_top_toolbar_list[i][1];
					span.title=vis_top_toolbar_list[i][0];
					$(span).bind("click", vis_top_toolbar_list[i][2]);
					$(span).hover(function() {$(this).animate({opacity: 0.25}, 100, function() {$(this).animate({opacity:1})})},function() {});
				}
				$this.append(span);
			}
		},
		load_global_message : function(message, highlightColor, duration) {
			if(message!="") {
				if(message.indexOf('alert-success')>0) $("#vis_global_msg_div").removeClass('alert-danger');
				else $("#vis_global_msg_div").addClass('alert-danger');
				$("#vis_global_msg_div").stop().html(message).show();
				setTimeout( function(){ $("#vis_global_msg_div").hide().html(''); }, 1000);
			}
		}
	};
	$.fn.visInterface = function( method ) {
		if ( methods[method] ) {
			return methods[method].apply( this, Array.prototype.slice.call( arguments, 1 ));
		} else if ( typeof method === 'object' || !method ) {
		  	return methods.init.apply( this, arguments );
		} else {
		  	$.error('Method '+method+' does not exist on jQuery.visInterface');
		}    
	};
})( jQuery );

(function($) {
	var methods={
     	init : function(options, callback) {
			if(options) {$.extend(settings, options);}
			
			//$("#vis_global_opt_con").css("display", "block");
			var $this = $(this); 
			var action = settings.vis_action;
		
			$.ajax({
				url: 'index.php?vis_tmpst=new Date().getTime()',
				data: settings,
				type: "POST",
				//context: document.body,
				success: function(data) { 
					if(action=="load_module" || settings.vis_dadd_type=='yes') {
						$this.append(data);
						settings.vis_tab_name="";
						settings.vis_dadd_type='';
					}
					else if(settings.vis_as_val==1) {
						$this.val($this.val()+data);
						settings.vis_as_val=0;
					}
					//else $this.html(data);
					else 
					if((location.hash).replace(/'/g, '')==action){$this.html(data);} 
					else if(action=='' || action===undefined || action.indexOf('#') < 0){ $this.html(data);}
					else if(decodeURI(location.hash)==action){$this.html(data);} 
					
					//alert('Blank------'+location.hash+'------'+action);
					//if(callback) callback();
					if(typeof settings.vis_header_title!="undefined" && settings.vis_header_title!='') {
						document.title=settings.vis_header_title;
						settings.vis_header_title='';
					}
					$("#vis_global_opt_con").css("display", "none");
                    var vis_operation = settings.vis_operation;
                    var vis_action = settings.vis_action;
                    var vis_subaction = settings.vis_subaction;
					settings={}; 
                    /* To disable header & footer mass actions on list pages */
                    if(vis_operation != "check_automation" && vis_operation != "list_contents"){
                        toggle_mass_actions();		
                    }					
					if($(".selectpicker").length > 0) { $(".selectpicker").selectpicker(); }
                    if(vis_operation == "load_lists"){ $("#"+vis_action+" .selectpicker").first().next().children().first().trigger("click"); }
                    if(vis_operation == "list_contents"){ 
						$("#"+vis_action+"_"+vis_subaction+" .selectpicker").first().next().children().first().trigger("click"); 
						if($("#get_macros_up .bootstrap-select > .dropdown-menu").length) { 
							$("#get_macros_up .bootstrap-select > .dropdown-menu").css('width', 'auto');
						}
					}
                    $("#vis_problems_search_form button").removeClass("bg-empty").addClass("btn-default");
					$( "body" ).on( "click", function() {
						if($(".popover").length) { 
							$("[id^='macro_']").popover('destroy').removeAttr("data-content").removeAttr("data-original-title"); 
						}
					});
				},
				error: function(xhr, ajaxOptions, thrownError) {$("#vis_global_msg_div").visInterface("load_global_message", "Error: "+xhr.status+" - "+thrownError);}
			});
			
		} ,
		load_hash_action : function (hash, options, callback) { 
			if(options){$.extend(settings, options);}
			var vis_action=hash.split("/");
			if(vis_action[1] == 'selfhelp') { vis_action[1] = 'solutions'; }
			if(typeof vis_modules_list[vis_action[1]]=="undefined") return false;
			var tab_name=vis_modules_list[vis_action[1]].vis_module_name;
			if(typeof vis_action[3]!="undefined") tab_name=vis_action[3];
			tab_name=tab_name.replace(/_/g, " ");
			if(vis_action[1]!="ticket" && vis_action[2]!='view_sentmail' && vis_action[2]!='sentmail_details') $("#vis_left_panel_div").hide();
            else if((vis_action[2]=='view_sentmail' && !$.isNumeric(vis_action[4])) || (vis_action[2]=='sentmail_details' && !$.isNumeric(vis_action[4])) || vis_action[2] == 'sentmail_details_log') $("#vis_left_panel_div").hide();
			else {
				if(!$("#vis_left_panel_div").is(":visible")) $("#vis_left_panel_div").show().css('height', $("#vis_left_panel_div").height()).visExecution('load_area', {'vis_module':"home", 'vis_operation':'load_left_panel', 'vis_load_tabs': false});
			}
            var function_names = ["view_tasks", "quick_view","view_update_tasks","view_blabs", "view_trend_blab","view_staff_blab","filter_problem", "problems_details", "filter_changes", "changes_details", "filter_releases", "releases_details","view_forum","add_forum_topic","get_topic_list","topic_details","get_all_categories","forum_filter","edit_topic","forum_list","new_task"];  
			if(function_names.indexOf(vis_action[2])!=-1 && vis_action[1]!='billing') {
				if(!$("#vis_right_panel_div").is(":visible")) $("#vis_right_panel_div").show();				
				$("#vis_right_panel_div").visExecution('load_area', {'vis_module':"home", 'vis_operation':'load_right_panel', 'vis_current_module':vis_action[1], 'vis_current_operations':vis_action[2],'vis_load_tabs': false});
			}		
            else $("#vis_right_panel_div").hide();
			$("#vis_workpanel_div").visExecution('load_module', tab_name, {
				'vis_module':vis_action[1],
				'vis_operation':vis_action[2],
				'vis_action':hash.replace(/\'/g, '')
			});
		},
		load_area : function(options, callback) {
			if(options){$.extend(settings, options);}
			if($(this).attr('id') == 'vis_right_panel_div') $(this).hide();
			$(this).visExecution(settings);
			if(!$(this).is(":visible")) {
				if(!(jQuery(this).attr('class') != undefined && jQuery(this).hasClass('vis_input'))) $(this).show();
			}
			if($(this).attr('id') == 'vis_right_panel_div') { $(this).css('height', $("#vis_right_panel_div").height()).css('display','table-cell'); 
			}
		},
		reply_forward : function(options, callback) {			
			if($(this).html()==""){
				$('#vis_workpanel_div').scrollTop(0);
				$(this).html('<div class="m h4 font-bold m-l-none">Loading...</div>');
				if(typeof options.vis_post_id!="undefined" && options.vis_post_id>0){
					$(this).visExecution('load_area', {'vis_module':'ticket', 'vis_operation':'ticket_reply_form', 'vis_department_id':options.vis_department_id, 'vis_domain_id':options.vis_domain_id, 'vis_ticket_id':options.vis_ticket_id, 'vis_action':options.vis_action, 'vis_post_id': options.vis_post_id});
				}else{
					$(this).visExecution('load_area', {'vis_module':'ticket', 'vis_operation':'ticket_reply_form', 'vis_department_id':options.vis_department_id, 'vis_domain_id':options.vis_domain_id, 'vis_ticket_id':options.vis_ticket_id, 'vis_action':options.vis_action});
				}
			}
			else $("#vis_global_msg_div").visInterface("load_global_message", "To move to next operation, please discard current changes");
		},
		load_module : function (tab_name, options, callback) {
			tab_name = decodeURIComponent(tab_name);
			tab_name = tab_name.replace("%", "");
			tab_name = tab_name.replace('"', "");
			tab_name = decodeURIComponent(tab_name);			
			$(this).html('<div class="h4 font-bold" style="margin-top:20%; text-align:center;font-weight:bold">Loading...</div>');
			if(options){$.extend(settings, options);}
			if(settings.vis_module == "selfhelp") { settings.vis_module = "solutions"; }
			if((tab_name == "Settings" && settings.vis_module == "setting") || (tab_name == "Clients" &&  settings.vis_module == "client") || (tab_name == "Reports" && settings.vis_module == "report"))
				document.title = vis_modules_list[settings.vis_module].vis_header_title  ;
			else
				document.title = (tab_name.toLowerCase() != settings.vis_module.toLowerCase()) ? (tab_name+" - "+vis_modules_list[settings.vis_module].vis_header_title) : vis_modules_list[settings.vis_module].vis_header_title  ;			
			if(!tab_name) tab_name=vis_modules_list[settings.vis_module].vis_module_name;
			var hash="#/"+options.vis_module+"/"+options.vis_operation+"/"+$.trim(tab_name);
			if(options.vis_module === 'ticket' && options.vis_operation === 'filter_ticket' && options.vis_filter_id !== '' && options.vis_filter_id !== undefined ){   // append filter_id to url
                var hash_arr=hash.split('/');
                if(hash_arr.length>3 && ( hash_arr[4] === '' || hash_arr[4] !== options.vis_filter_id )){
                    hash += "/"+options.vis_filter_id;
                    if(options.vis_report==1) hash += "/"+options.vis_report;
                }
			} else if (options.vis_module === 'ticket' && options.vis_operation === 'filter_queue_ticket' && settings.vis_department_id !== '' && settings.vis_department_id !== undefined && settings.vis_status_id !== '' && settings.vis_status_id !== undefined){   // append status_id, department_id to url
                var hash_arr = hash.split('/');
                if(hash_arr.length>3 && ( hash_arr[4] === '' || hash_arr[4] !== settings.vis_department_id && hash_arr[5] === '' || hash_arr[5] !== settings.vis_status_id ))
                    var temphash = "/"+settings.vis_department_id + "/" + settings.vis_status_id;
                    hash +=  temphash;
			} else if (options.hasOwnProperty('vis_action') && options.vis_operation != 'filter_queue_ticket') { // append id o hash
				var id=(options.vis_action).split('/'); 
				if(id.length>4){
					if(id[4] != '' && id[2]!='')					
					{	
                        hash += "/"+id[4];
                        if(options.vis_operation == 'filter_ticket' && id[5] == 1) hash += "/"+id[5];
                    } 
                }
            } else if (options.hasOwnProperty('vis_action') && options.vis_operation == 'filter_queue_ticket') { // append id o hash
				var id=(options.vis_action).split('/'); 
				if(id.length>4){
					if(id[4] != '' && id[2]!='')					
					{	var temphash = "/"+id[4]+"/"+id[5]; hash += temphash; } 
                }
            }
            else if (options.vis_module === 'billing' && options.vis_operation === 'get_invoices' && settings.vis_client_id !== '' && settings.vis_client_id !== undefined){   // append client_id to url
                var hash_arr = hash.split('/');
                if(hash_arr.length>3 && ( hash_arr[4] === '' || hash_arr[4] !== settings.vis_client_id))
                    hash += "/"+settings.vis_client_id;       
			}else if (options.vis_module === 'setting' && options.vis_operation === 'department_details' && options.vis_dept_id !== '' && options.vis_domain_name !==''){   
                hash="#/"+options.vis_module+"/"+options.vis_operation+"/"+options.vis_domain_name+' : '+options.vis_dept_name+'/'+options.vis_dept_id;
			}else if (options.vis_module === 'setting' && options.vis_id !== '' && options.vis_name !=='' && (options.vis_operation === 'status_details' || options.vis_operation === 'priority_details' || options.vis_operation === 'type_details' || options.vis_operation === 'label_details' || options.vis_operation === 'flag_details' || options.vis_operation === 'staff_details' || options.vis_operation === 'staffgroup_details' || options.vis_operation === 'quest_details' || options.vis_operation === 'impact_details' || options.vis_operation === 'risk_details' || options.vis_operation === 'change_type_details' || options.vis_operation === 'release_type_details' || options.vis_operation === 'holiday_details' || options.vis_operation === 'sla_details' || options.vis_operation === 'schedule_details' || options.vis_operation === 'edit_product' || options.vis_operation === 'edit_tax' || options.vis_operation === 'mailqueue_details' || options.vis_operation === 'etemplate_details')){   
                hash="#/"+options.vis_module+"/"+options.vis_operation+"/"+options.vis_name+'/'+options.vis_id;
			}
            if(settings.tag_id != undefined || settings.vis_label_id != undefined){ // append tag id, label_id to hash
                var hash_arr = hash.split('/');
                if(options.vis_operation == 'tag_search' && hash_arr.length>3 && ( hash_arr[4] == '' || hash_arr[4] != settings.tag_id )){
                     hash += "/" + settings.tag_id; 
                }
                if(options.vis_operation == 'search_label_tickets' && hash_arr.length>3 && ( hash_arr[4] == '' || hash_arr[4] != settings.vis_label_id )){
                    hash += "/" + settings.vis_label_id; 
                }
            }            
            document.location=hash;  
            $(this).visExecution(settings);
			// below code to hide left panel
			/*var vis_action=hash.split("/");
			if(vis_action[1]!="ticket" && vis_action[2]!='view_sentmail' && vis_action[2]!='sentmail_details') $("#vis_left_panel_div").hide();
            else if((vis_action[2]=='view_sentmail' && !$.isNumeric(vis_action[4])) || (vis_action[2]=='sentmail_details' && !$.isNumeric(vis_action[4]))) $("#vis_left_panel_div").hide();
			else {
				if(!$("#vis_left_panel_div").is(":visible")) $("#vis_left_panel_div").show().visExecution('load_area', {'vis_module':"home", 'vis_operation':'load_left_panel', 'vis_load_tabs': false});
			}
			var function_names = ["view_tasks", "quick_view","view_update_tasks","view_blabs", "view_trend_blab","view_staff_blab"]; 
			if(function_names.indexOf(vis_action[2])!=-1 && vis_action[1]!='billing') {
				if(!$("#vis_right_panel_div").is(":visible")) $("#vis_right_panel_div").show();				
				$("#vis_right_panel_div").visExecution('load_area', {'vis_module':"home", 'vis_operation':'load_right_panel', 'vis_current_module':vis_action[1], 'vis_current_operations':vis_action[2],'vis_load_tabs': false});
			}		
            else $("#vis_right_panel_div").hide();*/
			// move vertical scroll to top of window & add scroll to main workpanel div
			$("#vis_workpanel_div").scrollTop(0);
			if(options.vis_operation!="ticket_details" && options.vis_operation!="view_tasks" && !$("#vis_workpanel_div").hasClass("scrollable"))
			{
				$("#vis_workpanel_div").addClass("scrollable");
				if(GetIEVersion() > 0){
					$("#vis_workpanel_div").css('height',(GetHeightForBrowser()-45)+'px');
				}
			}
		},
		load_tab : function(tab_name, options, hash) {
			tab_name = tab_name.replace("%", ""); 
			tab_name = tab_name.replace('"', "");		
			tab_name = decodeURIComponent(tab_name);
			if(options){$.extend(settings, options);}
			var $tabs=$("#"+vis_modules_list[settings.vis_module].vis_tab_name);
			var nameOfTab=tab_name;
			var tabNameExists=false;
			var href;
			var index; 
			for(x in vis_modules_list) {$('#'+vis_modules_list[x].vis_tab_name).hide();}
			//$('#'+vis_modules_list[settings.vis_module].vis_tab_name).show();
			document.title=tab_name+" - "+vis_modules_list[settings.vis_module].vis_header_title;
		/*	if(tabNameExists) $tabs.tabs("select",index);
			else {*/
				var vis_url="index.php?";
				for (var prop in settings) {vis_url+=prop+"="+encodeURIComponent(settings[prop])+"&";}
				vis_url+="vis_tmpst="+new Date().getTime();

				if(typeof hash=="undefined") hash="#/"+settings.vis_module+"/"+settings.vis_operation+"/"+tab_name;
				
				$tabs.visInterface("add_new_tab", vis_url, tab_name, hash, options);
			//}
			settings={};
		},
		load_operations : function(options) { 
			var loading_area = $(this).attr('id');			
			if(options) {$.extend(settings, options);}
			if(typeof options.vis_form!="undefined") { 
				var form_data=$('#'+settings.vis_form+' :input').serialize(); 
				if(typeof settings.vis_action!="undefined") settings.vis_action="action="+settings.vis_action+"&"+form_data;
				else settings.vis_action="&"+form_data;
				options.vis_form="";
				if(settings.vis_loading=="undefined"){
					show_loading_text(loading_area);
				}
 				$(this).visExecution(settings);
			}
			else{
				if(settings.vis_loading=="undefined"){
					show_loading_text(loading_area);
				}
				$(this).visExecution(settings);
			}
		},
		submit_form : function(options) {			
			if((curr_stamp) > Date.now()-1000){
				//alert(curr_stamp);
			}
			else {
			curr_stamp = Date.now();				
			if(options){$.extend(settings, options);}
			if(typeof settings.vis_form!="undefined") { 
                if(settings.vis_operation == 'open_new_ticket' && $("#vis_internal_ticket").val()==0 && $("#token-input-vis_new_ticket_list_client").val()!=''){
                      $("#vis_new_ticket_list_client").tokenInput("add", {id: '0', contactDetails: $("#token-input-vis_new_ticket_list_client").val()});
                }
                if(settings.vis_operation == 'open_new_ticket' && $("#vis_internal_ticket").val()==0 && $("#token-input-vis_people").val()!=''){
                    $("#vis_people").tokenInput("add", {id: '0', email: $("#token-input-vis_people").val()});
                }
				if(settings.vis_operation == 'open_new_ticket' && $("#vis_internal_ticket").val()==0 && $("#token-input-vis_bcc").val()!=''){
                    $("#vis_bcc").tokenInput("add", {id: '0', email: $("#token-input-vis_bcc").val()});
                }			
                if(settings.vis_operation == 'update_ticket_client_properties' && $("#token-input-vis_email").val()!='' && ( typeof $("#token-input-vis_email").val()!='undefined')){
                    $("#vis_email").tokenInput("add", {id: '0', email: $("#token-input-vis_email").val()});
                }
                if(settings.vis_operation == 'reply_ticket' && $("#vis_internal_ticket").val()==0 && $("#token-input-vis_to_email").val()!=''){
					if(settings.vis_channel_id == 2)
                    $("#vis_to_email").tokenInput("add", {id: '0', contact_number: $("#token-input-vis_to_email").val()});
                    else  $("#vis_to_email").tokenInput("add", {id: '0', email: $("#token-input-vis_to_email").val()});
                }
				if(settings.vis_operation == 'reply_ticket' && $("#vis_internal_ticket").val()==0 && $("#token-input-vis_bcc").val()!=''){
                    $("#vis_bcc").tokenInput("add", {id: '0', email: $("#token-input-vis_bcc").val()});
                }
                if(settings.vis_operation == 'reply_ticket' && $("#vis_internal_ticket").val()==0 && $("#token-input-vis_people_new").val()!=''){
                    $("#vis_people_new").tokenInput("add", {id: '0', email: $("#token-input-vis_people_new").val()});
                }
                 if(settings.vis_operation == 'forward_ticket' && $("#token-input-vis_to_email_"+settings.vis_ticket_id).val()!=''){
                    $("#vis_to_email_"+settings.vis_ticket_id).tokenInput("add", {id: '0', email: $("#token-input-vis_to_email_"+settings.vis_ticket_id).val()});
                }
                if(settings.vis_operation == 'forward_ticket' && $("#token-input-vis_people").val()!=''){
                    $("#vis_people").tokenInput("add", {id: '0', email: $("#token-input-vis_people").val()});
                }
				if(settings.vis_operation == 'forward_ticket' && $("#token-input-vis_bcc").val()!=''){
                    $("#vis_bcc").tokenInput("add", {id: '0', email: $("#token-input-vis_bcc").val()});
                }
                /*if((settings.vis_operation == 'merge_clients' || settings.vis_operation == 'merge_contact') && $("#token-input-vis_email").val()!=''){                    
                    $("#vis_tempemail").val($("#token-input-vis_email").val());
					$("#vis_email").val($("#token-input-vis_email").val());
                }*/
				if(settings.vis_operation == 'add_client' && $("#token-input-vis_organization").val()!='' && settings.vis_static_area != 'vis_client_add_modal'){
                    $("#vis_organization").tokenInput("add", {id: '0', group_name: $("#token-input-vis_organization").val()});
                }
                if(settings.vis_operation == 'new_gcal' && $("#token-input-vis_event_guest_email").val()!='' && $("#vis_event_guest_email").length){
                    $("#vis_event_guest_email").tokenInput("add", {id: '0', email: $("#token-input-vis_event_guest_email").val()});
                }
				var form_data=$(this).parents().find('#'+settings.vis_form).serialize();
				if(typeof settings.vis_action!="undefined") settings.vis_action="action="+settings.vis_action+"&"+form_data;
				else settings.vis_action=form_data;
			
				$("#vis_global_msg_div").visExecution(settings);
			}
			else $(this).visExecution(settings);
			}
		},
		load_file_message : function(option) {
			$(settings.vis_upload_area).append(option.vis_message);
			$(settings.vis_upload_form_area).val($(settings.vis_upload_form_area).val()+option.vis_attachments);
			if($('#attachedMedia'))
			{$('#attachedMedia').show();}
			settings.vis_upload_area="";
			settings.vis_upload_form_area="";
		},
		load_profile : function(option) {	
			if(option.vis_client_portal==1)
			{
				$("#vis_manage_logo").html(option.vis_message);
				$("#clear_client_logo_Img").html(option.vis_button);
			}
			else if(option.vis_manage_portal==1)
			{
				$("#vis_manage_logo").html(option.vis_message);
				$("#clear_manage_logo_Img").html(option.vis_button);
			}else if(option.vis_favicon_client_portal==1)
			{
				//alert(option.vis_message);
				$("#vis_favicon_img").html(option.vis_message);
				$("#clear_client_favicon_Img").html(option.vis_button);
				
			}	else if(option.vis_favicon_manage_portal==1)
			{
				//alert(option.vis_message);
				$("#vis_manage_favicon_img").html(option.vis_message);
				$("#clear_manage_favicon_Img").html(option.vis_button);
			}	
			 else if(option.vis_channel!=1 && option.vis_channel!=2)	
			{ var headerpromsg=option.vis_message;
				$("#vis_header_profile_img").html(headerpromsg.replace('"lg','"sm'));	
				$("#vis_profile_img").html(option.vis_message);
				$("#vis_staff_profile_img").html(option.vis_message);
				$("#clearImg").html(option.vis_button);
				
			}
			else if(option.vis_channel==2)
			{
			$("#vis_channel_img").html(option.vis_message);
			$("#clearnewchnImg").html(option.vis_button);
			}
			else if(option.vis_channel==1)
			{
			$("#vis_channel_update_img").html(option.vis_message);
			$("#clearchnlImg").html(option.vis_button);
			}
			settings.vis_upload_area="";
			settings.vis_upload_form_area="";
		},
		upload_file : function(options) {
			if(options){$.extend(settings, options);}
			$this=$(this).parents().find('#'+settings.vis_form+":last");
			var target=$this.attr("target");
			var action=(typeof options.vis_action!="undefined" && options.vis_action!="")?options.vis_action:"index.php?vis_module=ticket&vis_operation=upload_file";
			$this.attr("action", action);
			$this.attr("target", "vis_hidden_frame");
			$this.attr("enctype", "multipart/form-data");
			$this.attr("encoding", "multipart/form-data");
			settings.vis_upload_area=$this.find(settings.vis_static_area+":last");
			settings.vis_upload_form_area=$this.find(settings.vis_form_attachment_area+":last");
			
			if(GetIEVersion() > 0) 
				{
				var files = $this.find('input[name="files"]'); 
$(settings.vis_static_area).append('<div id="loadimg" class="col-sm-3"><span class="vh vh-refresh vh-spin text-primary col-sm-3"></span><div>');
			var fdata = new FormData($($this)[0]);
			var t = setTimeout(function () {uploadfiles(action,fdata);}, 1);
				}else{
					$this.submit();
					 $(this).val("");
				}
				
           
		}
	};
	var settings={
		'vis_module' : '',
		'vis_operation' : '',
		'vis_action' : '',
		'vis_area_height' : '',
		'vis_dadd_type' : ''
	};
	$.fn.visExecution = function( method ) { 
		if ( methods[method] ) {
			return methods[method].apply( this, Array.prototype.slice.call( arguments, 1));
		} else if ( typeof method === 'object' || !method ) {
		  	return methods.init.apply( this, arguments );
		} else {
		  	$.error('Method '+method+' does not exist on jQuery.visExecution');
		}
	};
})(jQuery);

function locationHashChanged(){
	$(window).visExecution('load_hash_action', location.hash);
}
$(document).ready(function() {
    window.onhashchange = locationHashChanged;
});	
function display_pie_charts(channels,channelNms,channelPer,clrs,opArea,chartArea)
{
	var opts = "";
	for(i=0;i<channels.length;i++)
	{
		opts+= '<div class="list-group-item"><span><i class="vh vh-circle" style="color:'+clrs[i]+'"></i> '+channelNms[i]+':</span> '+channelPer[i]+'%</div>';
	}
	$(opArea).html(opts);
	var pieColors =  ['#E68B27','#4C8B16','#FFCC00','#3B5998','#55ACEE'];
	$(chartArea).sparkline(channels,{type:'pie',height:"175",sliceColors:clrs,disableHighlight:true});
	if($('#pdfSlaDiv'))
	{
		$('#pdfSlaDiv').show();
	}
}
function display_ticket_types(ticket_types,chartColors)
{
	$(".ticket_type_pie-donut").length && $.plot($(".ticket_type_pie-donut"), ticket_types, {
    series: {
      pie: {
        innerRadius: 0.4,
        show: true,
        stroke: {
          width: 0
        },
        label: {
          show: true,
          threshold: 0.05
        },
      }
    },
    colors: chartColors,
    grid: {
        hoverable: true,
        clickable: false
    },
    tooltip: true,
    tooltipOpts: {
      content: "%s: %p.0%"
    }
  });
}
function display_ticket_report(criteria,newTickets)
{
  var xAxisData = [];
  if(criteria == 2)
  {	
		xAxisData = [[0, "Sun"],[1, "Mon"], [2, "Tue"], [3, "Wed"],[4, "Thu"], [5, "Fri"], [6, "Sat"]];
  }
  else
  {
	for(i=0;i<=31;i++)
	{ 
		xAxisData[i]=[i,i];
	}
  }
  $("#flot-1ine-ticket").length && $.plot($("#flot-1ine-ticket"), [{
          data: newTickets
      }], 
      {
        series: {
            lines: {
                show: true,
                lineWidth: 1,
                fill: true,
                fillColor: {
                    colors: [{
                        opacity: 0.3
                    }, {
                        opacity: 0.3
                    }]
                }
            },
            points: {
                radius: 3,
                show: true
            },
            grow: {
              active: true,
              steps: 50
            },
            shadowSize: 2
        },
        grid: {
            hoverable: true,
            clickable: true,
            tickColor: "#f0f0f0",
            borderWidth: 1,
            color: '#f0f0f0'
        },
        colors: ["#1bb399"],
        xaxis:{
			ticks: xAxisData
        },
        yaxis: {
          ticks: 5
        },
        tooltip: true,
        tooltipOpts: {
          content: "chart: %x.1 is %y.4",
          defaultTheme: false,
          shifts: {
            x: 0,
            y: 20
          }
        }
      }
  );
}
function display_bar_chart(chartArea,xAxisData,slaData,yaxisLabel)
{
  $(chartArea).length && $.plot($(chartArea), [{
          data: slaData
      }], 
      {
        series: {
                bars: {
                    show: true
                }
            },
            bars: {
                align: "center",
                barWidth: 0.5
            },
        grid: {
            hoverable: true,
            clickable: true,
            tickColor: "#f0f0f0",
            borderWidth: 2,
            color: '#f0f0f0'
        },
        legend: {
                noColumns: 0,
                labelBoxBorderColor: "#000000",
                position: "nw"
            },
        colors: ["#1bb399"],
        xaxis:{
			axisLabelUseCanvas: true,
			axisLabelPadding: 10,
			ticks: xAxisData,
			min:-1.5
        },
        yaxis: {     
			axisLabel: yaxisLabel,
			axisLabelUseCanvas: true,
			axisLabelPadding: 3,
			axisLabelFontSizePixels: 16,
			ticks: 5
        },
        tooltip: true,
        tooltipOpts: {
          content: "chart: %x.1 is %y.4",
          defaultTheme: false,
          shifts: {
            x: 0,
            y: 20
          }
        }
      }
  );
  $('#pdfDiv').show();
}
function generatePDF(canvasDiv,pdfTitle,toDisplay,pdfNm,pdfDuration,pdfDate,dateSel)
{
	var durationSel = $('.durationSelected').val();
	var otherSel = $('.otherSelected').val();
	var d = new Date();
	var date = dateSel+' ' +d.getHours()+':'+d.getMinutes();
	var ele = $(canvasDiv);
	html2canvas([ele.get(0)], {
		onrendered: function(canvas) {
			var imgData = canvas.toDataURL('image/png');
			var doc = new jsPDF('landscape');                    
			doc.setFontSize(12);
			doc.text(20,15,pdfNm+": "+pdfTitle);
			doc.text(20,25,pdfDuration+": "+durationSel);
			doc.text(20,35,toDisplay+": "+otherSel);
			doc.text(20,45,pdfDate+": "+date);
			doc.addImage(imgData, 'PNG', 20, 55, 250, 90); 
			//Set PDF properities
			doc.setProperties({
				title:pdfTitle+' report',
			});  
			if(navigator.userAgent.indexOf("Chrome") != -1 )
    {
       doc.save(pdfTitle.trim()+'_report.pdf'); 
    }else{
			doc.output('dataurlnewwindow');
				}
		}
	});
}
function show_loading_text(loading_area){ 
	if(loading_area != "vis_global_msg_div" 
        && loading_area != 'vis_notify_count' 
        && (typeof(loading_area) != undefined && loading_area != undefined && loading_area.search('vis_lock_ticket_')))
		$("#"+loading_area).html('<div class="m h4">Loading...</div>');
}
// resize input box as per placeholder width for recepient, people & tags
function resize_input_rec_pe_tags() { 
    //firstly take the content or placeholder if content is missing
    var content = $(this).prop("placeholder");
    //create testing element with same content as input
    var widthTester = $("<span id='hidden_placeholder'>"+content+"</span>").hide();
    //place testing element into DOM after input (so it inherits same formatting as input does) 
    $("body").append(widthTester);
    //set inputs width; you may want to use outerWidth() or innerWidth()
    //depending whether you want to count padding and border or not
    $(this).css("width", widthTester.outerWidth()+25+"px"); 
    //remove element from DOM
    widthTester.remove();
 }
/* Following funtion used on ticket details page to show user (staff/client) details on mouse over */
var ajax_request;
function show_user_details(submitter, submitter_id, post_id ,task_id ,staff_id ,isclientdetails,topic_id){ 
	var popover_id=action_data="";
    if (post_id != undefined && post_id != null){
        popover_id=$("#user_"+post_id+"_"+submitter+"_"+submitter_id);
        action_data={ 'vis_module':'ticket', 'vis_operation':'show_user_details', 'vis_post_id':post_id, 'vis_submitter':submitter, 'vis_submitter_id': submitter_id };
    }
    else if(task_id != undefined && task_id != null){
		popover_id=$("#user"+task_id+"_"+submitter_id);
        action_data={ 'vis_module':'ticket', 'vis_operation':'show_user_details', 'vis_task_id':task_id, 'vis_submitter':submitter, 'vis_submitter_id': submitter_id };
     }
     else if(topic_id != undefined && topic_id != null){
		
		popover_id=$("#user_"+topic_id);
		action_data={ 'vis_module':'forums', 'vis_operation':'show_user_details', 'vis_submitter':submitter, 'vis_submitter_id': submitter_id, 'vis_tipic_id':'show_user_details', 'vis_submitter':submitter};
     }
	 else if(staff_id != undefined && staff_id != null){
		popover_id=$("#user_"+submitter_id);
		action_data={ 'vis_module':'problem', 'vis_operation':'show_user_details', 'vis_submitter':submitter, 'vis_submitter_id': submitter_id };
     }else {
        popover_id=$("#user_"+submitter_id);
        action_data={ 'vis_module':'ticket', 'vis_operation':'show_user_details', 'vis_submitter':submitter, 'vis_submitter_id': submitter_id };
    }
	if($(".popover").length){
		popover_id.popover('destroy').removeAttr("data-content").removeAttr("data-original-title");
	}
	else{ 
		ajax_request = $.ajax({
			url: 'index.php?vis_tmpst=new Date().getTime()',
			data: action_data,
			type: "POST",
			dataType: "html",
			success: function(data) {
				popover_id.attr("data-html","true");
                if(isclientdetails==1) popover_id.attr("data-placement","bottom");                
				popover_id.attr("data-content",data);
				popover_id.popover('show');
			}
		}); 
	}
}
/* Following funtion used on ticket details page to hide user (staff/client) details on mouse out */
function hide_user_details(obj){
	if(typeof ajax_request !== 'undefined') ajax_request.abort();
	$("#"+obj.id).popover('destroy').removeAttr('data-html data-content data-original-title');
}
/* To disable header & footer mass actions on list pages */
function toggle_mass_actions(){
    var checkboxes = ($("[id^='vis_global_mass_chk_']").length > 0) ? $("[id^='vis_global_mass_chk_']") : (($("[id^='vis_ticket_mass_chk_']").length > 0) ? $("[id^='vis_ticket_mass_chk_']") : "");
    if(checkboxes != ""){                        
        header_dropdown_btns = $(".vis_mass_action"),
        footer_dropdown_btns = $(".vis_mass_action_footer");
        var checkedAtLeastOne = false;                 
        header_dropdown_btns.addClass("hide");
        footer_dropdown_btns.addClass("hide");
        checkedAtLeastOne = checkboxes.is(":checked");
        if(checkedAtLeastOne){ 
			header_dropdown_btns.removeClass("hide");
			footer_dropdown_btns.removeClass("hide");
		} else {
			header_dropdown_btns.addClass("hide");
			footer_dropdown_btns.addClass("hide");
		}
        checkboxes.unbind().click(function() {                            
            checkedAtLeastOne = checkboxes.is(":checked");
            if(checkedAtLeastOne){ 
                header_dropdown_btns.removeClass("hide");
                footer_dropdown_btns.removeClass("hide");
            } else { $("#pdf_set").val('');
                header_dropdown_btns.addClass("hide");
                footer_dropdown_btns.addClass("hide");
            }
        });
        // table header select/deselect all checkbox
        $(document).on('change', 'table thead [type="checkbox"]', function(e){
            e && e.preventDefault();
            var $checked = $(e.target).is(':checked');
            if($checked){
                header_dropdown_btns.removeClass("hide");
                footer_dropdown_btns.removeClass("hide");
            } else {
                header_dropdown_btns.addClass("hide");
                footer_dropdown_btns.addClass("hide");
            }
        });
    }
}
function display_pie_charts_data(channels,channelNms,clrs,opArea,chartArea)
{
	var opts = "";
	for(i=0;i<channels.length;i++)
	{
		opts+= '<div class="list-group-item"><span><i class="vh vh-circle" style="color:'+clrs[i]+'"></i> '+channelNms[i]+':</span> '+channels[i]+'</div>';
	}
	$(opArea).html(opts);
	var pieColors =  ['#E68B27','#4C8B16','#FFCC00','#3B5998','#55ACEE'];
	$(chartArea).sparkline(channels,{type:'pie',height:"175",width:"200",sliceColors:clrs,disableHighlight:true});
	if($('#pdfGraphExport'))
	{
		$('#pdfGraphExport').show();
	}
}
function getScript(url){
    var script = document.createElement('script');
    script.src = url;
    var head = document.getElementsByTagName('head')[0], done=false;
    script.onload = script.onreadystatechange = function(){
        if (!done && (!this.readyState || this.readyState == 'loaded' || this.readyState == 'complete')) {
            done=true;
            script.onload = script.onreadystatechange = null;
            head.removeChild(script);
        }
    };
    head.appendChild(script);
}
function generateGraphPDF(titlePdf,durationPdf,deptPdf,graphDiv,graphOpts,pdfDate,dateSel)
{
	var durationSel = $('.durationSelected').val();
	var otherSel = $('.otherSelected').val();
	var d = new Date();
	var date = dateSel+' '+d.getHours()+':'+d.getMinutes();
	var ele = $('.'+graphDiv);
	var doc = new jsPDF('landscape');
	html2canvas([ele.get(0)], {
		onrendered: function(canvas) {
			var imgData = canvas.toDataURL('image/png');
			doc.setFontSize(12);
			doc.text(70,15,'Title - '+titlePdf);
			doc.text(70,25,durationPdf+" - "+durationSel);
			doc.text(70,35,deptPdf+" - "+otherSel); 
			doc.text(70,45,pdfDate+": "+date);
			doc.addImage(imgData, 'PNG', 70, 55, 150, 50); 
			//Set PDF properities
			doc.setProperties({
				title: titlePdf+' report',
			}); 
			doc.fromHTML($('#'+graphOpts).get(0), 100, 60, {
			'elementHandlers': specialElementHandlers
			});
			doc.output('dataurlnewwindow');     
		}
	});
	var specialElementHandlers = {
	'#editor': function(element, renderer){
	return true;
	}};
	
}
function ticket_apply_macro(macro_id, vis_department_id, ticket_id) { 
	$("#macro_title").html('<a data-html="true" class="link" href="javascript:void(0);" id="macro_'+macro_id+'" rel="popover" onclick="show_macro_details('+macro_id+');">View</a>');
	$('#vis_global_msg_div').visExecution('load_operations', { 'vis_module': 'home', 'vis_operation': 'apply_macro', 'vis_department_id':vis_department_id, 'vis_macro_id':macro_id, 'vis_ticket_id':ticket_id });
}
function show_macro_details(macro_id){
	var popover_id = $("#macro_"+macro_id); 
	if($(".popover").length){
		close_popover(popover_id);
	}
	else{ 
		$.ajax({
			url: 'index.php?vis_tmpst=new Date().getTime()',
			data: {'vis_module':'home', 'vis_operation':'show_macro_details', 'vis_macro_id':macro_id},
			type: "POST",
			dataType: "html",
			success: function(data) {
				var close_btn = "<button type='button' class='close pull-right' data-dismiss='popover'> &times;</button>Macro details&nbsp;";
				popover_id.attr("data-content",data);
				popover_id.attr("data-original-title",close_btn);									
				popover_id.popover('show');
				$("#macro_title .popover").css('width', 'auto').css('height', 'auto').css('max-width', '500px').css('max-height', '500px');
				$(".popover").css('top', $(".popover").position().top-20);
			},
			error: function(xhr, ajaxOptions, thrownError) {$("#vis_global_msg_div").visInterface("load_global_message", "Error: "+xhr.status+" - "+thrownError);}
		});
	}
}
function close_popover(popover_id) { 
	if(typeof(popover_id) == 'number') {
		var popover_id = $("#macro_"+popover_id); 
	}
	popover_id.popover('destroy').removeAttr("data-content").removeAttr("data-original-title");
}
function assign_owner(id, no_change_flag){	
    if($(".staff_"+id).prop('checked') != true){
        if(id!=0){         
            //remove_owner(0);
			if($(".staff_0").prop("checked") == true) {
				$(".staff_0").prop("checked", false); 
				$('#vis_owner_list').val('')
			};
			var temp = '';
            temp=$('#vis_owner_list').val();
            var temparr=temp.split(',');	
            if(temparr.indexOf(id) == -1 && $(".staff_"+id).length > 0) {
				var owner_id = (temp != "") ? temp+','+id : id; 
				$('#vis_owner_list').val(owner_id);
			}
        }else{ 
            $('.ticketowner :checked').each(function() {
                $(this).prop("checked", false);
                $("#owners_list").html('');
                $("#multipleownerlist").hide();
            });
            $('#vis_owner_list').val('0');
        }
        $(".staff_"+id).prop("checked", true);
        add_owner(id);        
    } else if (typeof(no_change_flag) == undefined){ 
        $(".staff_"+id).prop("checked", false);
        remove_owner(id);
        if($('.ticketowner .open :checked').size()<1){ 
            add_owner(0); 
            $(".staff_0").prop("checked", true);
            $("#owner_name").html('Unassigned');
        }
    }
}
function add_owner(id){ 
    if($('.ticketowner .open :checked').size()>1){ 
        $("#multipleownerlist").show();
        $("#owner_name").html('Multiple owners');
    }else{
        $('.ticketowner :checked').each(function() {
            var tempid=$(this).attr('class');
            var name=$("."+tempid).next().next().text();
            $("#owner_name").html(name);
        });
    }
	if(id > 0 && $(".staff_"+id).length > 0) {
		var name=$(".staff_"+id).next().next().text();
		var newDiv=document.createElement("DIV");
		var newList='<div class="btn-group pull-left m-l-sm m-b-xs"><span class="btn btn-xs alert-danger">'+name+'</span><button data-dismiss="alert" class="btn btn-xs alert-danger" type="button" onclick="remove_owner('+id+');"><span aria-hidden="true"><i class="vh vh-cross"></i></span><span class="sr-only">Close</span></button></div>';
		newDiv.id="owners_list_"+id;
		newDiv.innerHTML=newList;
		document.getElementById("owners_list").appendChild(newDiv);
	}
}
function remove_owner(id){
    $(".staff_"+id).prop("checked", false);
    var temp=$('#vis_owner_list').val();
    var temparr=temp.split(',');
    var tempowner='';
    $.each( temparr, function( key, value ) {
        if(value!=id && value!='') tempowner+=value+',';
    });
    $('#vis_owner_list').val(tempowner);
    $("#owners_list_"+id).remove();
    if($('.ticketowner .open :checked').size()<2){ 
        $("#multipleownerlist").hide();
        $('.ticketowner :checked').each(function() {
            var tempid=$(this).attr('class');
            var name=$("."+tempid).next().next().text();
            $("#owner_name").html(name);
        });
    }
}
$(document).ready(function() {
  $('body').keydown(function(event){ // Prevent enter event when modal visible
    if(event.keyCode == 13 && $('.modal').is(":visible") == true && ($(event.target)[0]!=$("textarea")[0])) { 
      event.preventDefault();
      return false;
    }
  });
});

function GetIEVersion() {
  var sAgent = window.navigator.userAgent;
  var Idx = sAgent.indexOf("MSIE");
  if (Idx > 0) 
    return parseInt(sAgent.substring(Idx+ 5, sAgent.indexOf(".", Idx)));
  else if (!!navigator.userAgent.match(/Trident\/7\./)) 
    return 11;

  else
    return 0; //It is not IE
}

function GetHeightForBrowser() {
        doc = document;
        return Math.max(
            Math.max(doc.body.scrollHeight, doc.documentElement.scrollHeight),
            Math.max(doc.body.offsetHeight, doc.documentElement.offsetHeight),
            Math.max(doc.body.clientHeight, doc.documentElement.clientHeight)
        );
    }
	
function uploadfiles(action,fdata)
{
	var $ajaxOptions = {
url: action,
headers: { "cache-control": "no-cache" },
async:false,
type: "POST",
enctype: 'multipart/form-data',
processData: false,
contentType: false,
data: fdata
//dataType: "JSON"
};
$.ajax($ajaxOptions).always(function (jqXHR, textStatus, errorMessage) {
	$('#loadimg').remove();
$("#vis_global_msg_div").html(jqXHR);

});
}